<?php
// ---------------- CORS ----------------
header("Access-Control-Allow-Origin: *"); // for dev only, replace with your frontend in prod
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// Handle OPTIONS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// ---------------- DATABASE ----------------
require "database.php";

// ---------------- READ INPUT ----------------
$data = json_decode(file_get_contents("php://input"), true);
$message = trim($data['message'] ?? "");
$session_id = $data['session_id'] ?? null;

// ---------------- CHECK MESSAGE ----------------
if ($message === "") {
    echo json_encode([
        "status" => false,
        "message" => "Message cannot be empty"
    ]);
    exit;
}

// ---------------- CHECK IF SESSION ENDED ----------------
if ($session_id) {
    $stmt = $pdo->prepare("SELECT status FROM chat_sessions WHERE session_id=?");
    $stmt->execute([$session_id]);
    $session = $stmt->fetch();

    if ($session && $session['status'] === 'ended') {
        echo json_encode([
            "status" => false,
            "ended" => true,
            "message" => "Chat has ended"
        ]);
        exit;
    }
}

// ---------------- CREATE SESSION IF NONE ----------------
if (!$session_id) {
    $session_id = uniqid("chat_", true);
}

// Insert or update session
$stmt = $pdo->prepare("
    INSERT INTO chat_sessions (session_id, status)
    VALUES (?, 'active')
    ON DUPLICATE KEY UPDATE last_activity = NOW()
");
$stmt->execute([$session_id]);

// ---------------- INSERT MESSAGE ----------------
$stmt = $pdo->prepare("INSERT INTO chats (session_id, sender, message) VALUES (?, 'user', ?)");
$stmt->execute([$session_id, $message]);

// ---------------- RESPONSE ----------------
echo json_encode([
    "status" => true,
    "session_id" => $session_id
]);
