<?php
// === CORS Headers ===
header("Access-Control-Allow-Origin: *"); // replace with frontend domain
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// === Database ===
require "database.php";

// Read JSON
$data = json_decode(file_get_contents("php://input"), true);

$session_id = trim($data['session_id'] ?? "");
$message = trim($data['message'] ?? "");

// Validate
if (!$session_id || !$message) {
    echo json_encode(["success" => false, "message" => "Missing session_id or message"]);
    exit;
}

// Insert bot reply
$stmt = $pdo->prepare(
  "INSERT INTO chats (session_id, sender, message) VALUES (?, 'bot', ?)"
);
$stmt->execute([$session_id, $message]);

echo json_encode(["success" => true]);
