<?php
const JWT_SECRET = "CHANGE_THIS_TO_A_LONG_RANDOM_SECRET";
const JWT_ISSUER = "securewallet-app";
const JWT_EXPIRY = 3600; // 1 hour

function base64UrlEncode($data) {
  return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function base64UrlDecode($data) {
  return base64_decode(strtr($data, '-_', '+/'));
}

function createJWT($payload) {
  $header = base64UrlEncode(json_encode(["alg"=>"HS256","typ"=>"JWT"]));
  $payload = base64UrlEncode(json_encode($payload));
  $signature = base64UrlEncode(
    hash_hmac("sha256", "$header.$payload", JWT_SECRET, true)
  );
  return "$header.$payload.$signature";
}

function verifyJWT($token) {
  $parts = explode(".", $token);
  if (count($parts) !== 3) return false;

  [$header,$payload,$signature] = $parts;

  $validSig = base64UrlEncode(
    hash_hmac("sha256", "$header.$payload", JWT_SECRET, true)
  );

  if (!hash_equals($validSig, $signature)) return false;

  $data = json_decode(base64UrlDecode($payload), true);
  if ($data["exp"] < time()) return false;

  return $data;
}
