<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
require "database.php";

$session_id = $_GET['session_id'] ?? "";

// Get session status
$stmt = $pdo->prepare(
  "SELECT status FROM chat_sessions WHERE session_id=?"
);
$stmt->execute([$session_id]);
$session = $stmt->fetch();

$status = $session['status'] ?? 'active';

// Get messages
$stmt = $pdo->prepare(
  "SELECT id, sender, message
   FROM chats
   WHERE session_id=?
   ORDER BY id ASC"
);
$stmt->execute([$session_id]);

echo json_encode([
  "status" => $status,
  "ended" => $status === 'ended',
  "messages" => $stmt->fetchAll(PDO::FETCH_ASSOC)
]);
