<?php
header("Access-Control-Allow-Origin: *"); // for testing
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(200);
  exit;
}

require "database.php";

$session_id = $_GET['session_id'] ?? "";
if (!$session_id) {
    echo json_encode(["ended" => false, "messages" => []]);
    exit;
}

// Check session status
$stmt = $pdo->prepare("SELECT status FROM chat_sessions WHERE session_id=?");
$stmt->execute([$session_id]);
$session = $stmt->fetch();
$ended = $session && $session['status'] === 'ended';

// Fetch messages
$stmt = $pdo->prepare("SELECT sender, message FROM chats WHERE session_id=? ORDER BY id ASC");
$stmt->execute([$session_id]);
$messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode([
    "ended" => $ended,
    "messages" => $messages
]);
