<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(200);
  exit;
}

require "database.php";

$data = json_decode(file_get_contents("php://input"), true);
$session_id = $data['session_id'] ?? "";

if (!$session_id) {
  http_response_code(400);
  exit;
}

$stmt = $pdo->prepare(
  "UPDATE chat_sessions SET status='ended' WHERE session_id=?"
);
$stmt->execute([$session_id]);

echo json_encode(["success" => true]);
