<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require "database.php";
require "jwt.php";

// Check Authorization header
$headers = getallheaders();
if (!isset($headers['Authorization'])) {
    echo json_encode(["status" => false, "message" => "No token provided"]);
    exit;
}

$auth = $headers['Authorization'];
$token = str_replace("Bearer ", "", $auth);

$payload = verifyJWT($token);
if (!$payload) {
    echo json_encode(["status" => false, "message" => "Invalid token"]);
    exit;
}

// Read input
$data = json_decode(file_get_contents("php://input"), true);
$wallet_id = $data['wallet_id'] ?? null;

if (!$wallet_id) {
    echo json_encode(["status" => false, "message" => "Wallet ID missing"]);
    exit;
}

// Delete wallet
$stmt = $pdo->prepare("DELETE FROM wallets WHERE id = ?");
if ($stmt->execute([$wallet_id])) {
    echo json_encode(["status" => true, "message" => "Wallet deleted successfully"]);
} else {
    echo json_encode(["status" => false, "message" => "Failed to delete wallet"]);
}
