<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

require "database.php";
require "jwt.php";

// ✅ Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }

// Get Bearer token
$headers = apache_request_headers();
$authHeader = $headers['Authorization'] ?? '';
if (!preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    echo json_encode(['status'=>false,'message'=>'Missing token']);
    exit;
}
$token = $matches[1];

// Verify token
$payload = verifyJWT($token);
if (!$payload) {
    echo json_encode(['status'=>false,'message'=>'Invalid token']);
    exit;
}

$data = json_decode(file_get_contents("php://input"), true);
$current = $data['current_password'] ?? '';
$new = $data['new_password'] ?? '';

if (!$current || !$new) {
    echo json_encode(['status'=>false,'message'=>'All fields are required']);
    exit;
}

// Fetch admin
$stmt = $pdo->prepare("SELECT password FROM admin WHERE id=?");
$stmt->execute([$payload['admin_id']]);
$admin = $stmt->fetch();

if (!$admin || !password_verify($current, $admin['password'])) {
    echo json_encode(['status'=>false,'message'=>'Current password is incorrect']);
    exit;
}

// Update password
$hash = password_hash($new, PASSWORD_DEFAULT);
$stmt = $pdo->prepare("UPDATE admin SET password=? WHERE id=?");
$stmt->execute([$hash, $payload['admin_id']]);

echo json_encode(['status'=>true,'message'=>'Password updated successfully']);
