<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");


// ✅ Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require "database.php";
require "jwt.php";

$data = json_decode(file_get_contents("php://input"), true);

$stmt = $pdo->prepare("SELECT * FROM admin WHERE email=?");
$stmt->execute([$data["email"]]);
$admin = $stmt->fetch();

if (!$admin || !password_verify($data["password"], $admin["password"])) {
  echo json_encode(["status"=>false,"message"=>"Invalid login => check your password and email"]);
  exit;
}

$payload = [
  "admin_id" => $admin["id"],
  "email" => $admin["email"],
  "exp" => time() + JWT_EXPIRY
];

$token = createJWT($payload);

echo json_encode([
  "status" => true,
  "token" => $token
]);
